<?php

namespace App\Models\Demarches;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ModeleLettre extends Model 
{

    protected $table = 'modele_lettres';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('nom', 'description', 'post_scriptum', 'observations', 'date_publication', 'date_derniere_modification', 'etat', 'est_publie', 'add_by');

    public function demarches()
    {
        return $this->belongsToMany('App\Models\Demarches\Demarche');
    }

    public function pieceJointes()
    {
        return $this->morphMany('App\Models\Demarches\PieceJointe', 'modele');
    }

}